package gov.va.med.mhv.integration.phr.stage.transfer;

import java.util.Date;

/**
 * StageReminder entity.
 * 
 */

public class StageAllergy extends StageEntity {

	public static final String RECORD_TYPE_COMMENT = "COMMENT";
	public static final String RECORD_TYPE_REACTION = "REACTION";
	public static final String RECORD_TYPE_DRUGCLASS = "DRUGCLASS";
	public static final String RECORD_TYPE_ALLERGY = "ALLERGY";

	// Fields
	private Date extractDate;

	private String recordType;

	private String recordId;

	private String allergyType;

	private String reactant;

	private String drugClass;

	private String reaction;

	private String allergyComment;

	private String observed;

	private String assigningFacility;

	private String assigningAuthority;

	private Date observationDatePrecise;
	
	private String observationDateImprecise;
	
	// Constructors

	/**
	 * default constructor do not provide auto initialization since this class
	 * can be used in findByExample
	 */
	public StageAllergy() {
		super();
		this.recordType = RECORD_TYPE_ALLERGY;
	}

	/** minimal constructor */
	public StageAllergy(Long oplock, Date createdDate, Date modifiedDate, String icn, String stationNumber,
			Long requestMsgCtrlId) {
		super();
		this.oplock = oplock;
		this.createdDate = createdDate;
		this.modifiedDate = modifiedDate;
		this.extractDate = modifiedDate;
		this.icn = icn;
		this.stationNumber = stationNumber;
		this.requestMsgCtrlId = requestMsgCtrlId;
		this.recordType = RECORD_TYPE_ALLERGY;
	}

	// Property accessors

	public String getAllergyComment() {
		return allergyComment;
	}

	public void setAllergyComment(String allergyComment) {
		this.allergyComment = doubleUnescapeHtml(allergyComment);
	}

	public String getDrugClass() {
		return drugClass;
	}

	public void setDrugClass(String drugClass) {
		this.drugClass = doubleUnescapeHtml(drugClass);
	}

	public Date getExtractDate() {
		return extractDate;
	}

	public void setExtractDate(Date extractDate) {
		this.extractDate = extractDate;
	}

	public String getReactant() {
		return reactant;
	}

	public void setReactant(String reactant) {
		this.reactant = doubleUnescapeHtml(reactant);
	}

	public String getRecordId() {
		return recordId;
	}

	public void setRecordId(String recordId) {
		this.recordId = doubleUnescapeHtml(recordId);
	}

	public String getRecordType() {
		return recordType;
	}

	public void setRecordType(String recordType) {
		this.recordType = doubleUnescapeHtml(recordType);
	}

	public String getAllergyType() {
		return allergyType;
	}

	public void setAllergyType(String allergyType) {
		this.allergyType = doubleUnescapeHtml(allergyType);
	}

	public String getObserved() {
		return observed;
	}

	public void setObserved(String observed) {
		this.observed = doubleUnescapeHtml(observed);
	}

	public String getReaction() {
		return reaction;
	}

	public void setReaction(String reaction) {
		this.reaction = doubleUnescapeHtml(reaction);
	}

	public String getAssigningFacility() {
		return assigningFacility;
	}

	public void setAssigningFacility(String assigningFacility) {
		this.assigningFacility = doubleUnescapeHtml(assigningFacility);
	}

	public String getAssigningAuthority() {
		return assigningAuthority;
	}

	public void setAssigningAuthority(String assigningAuthority) {
		this.assigningAuthority = doubleUnescapeHtml(assigningAuthority);
	}

	public Date getObservationDatePrecise() {
		return observationDatePrecise;
	}

	public void setObservationDatePrecise(Date observationTime) {
		this.observationDatePrecise = observationTime;
	}

	public String getObservationDateImprecise() {
		return observationDateImprecise;
	}

	public void setObservationDateImprecise(String observationTimeString) {
		this.observationDateImprecise = observationTimeString;
	}

	public String toString() {
		return  "StageAllergy {" + 
				", id=" + getId() + 
				", oplock=" + oplock +
				", createdDate=" + createdDate + 
				", modifiedDate=" + modifiedDate + 
				", icn='" + icn + '\'' +
				", stationNumber='"	+ stationNumber + '\'' + 
				", requestMsgCtrlId=" + requestMsgCtrlId + 
				", responseMsgCtrlId=" + responseMsgCtrlId + 
				", extractStatus='" + extractStatus + '\'' + 
				", recordStatus='" + recordStatus + '\'' + 
				", extractDate=" + extractDate + 
				", recordId='" + recordId + '\'' + 
				", recordType='" + recordType + '\'' + 
				", reactant='" + reactant + '\'' + 
				", allergyType='" + allergyType	+ 
				", drugClass='" + drugClass + '\'' + 
				", allergyComment='" + allergyComment + '\'' + 
				", observationDatePrecise='" + observationDatePrecise + '\'' +
				", observationDateImprecise='" + observationDateImprecise + '\'' +
				'}';
	}

	@Override
	public boolean equals(Object obj) {
		boolean result = false;
		result = String.valueOf(obj).equalsIgnoreCase(String.valueOf(this));
		return result;
	}

	public void setAK(StageEntityAK ak) {
		this.icn = ak.getIcn();
		// Station number is excluded because it comes from the response not the
		// request
		// in the case of allergies.

		// this.stationNumber=ak.getStationNumber();
		this.requestMsgCtrlId = ak.getRequestMsgCtrlId();
		this.responseMsgCtrlId = ak.getResponseMsgCtrlId();
	}

}
